/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.structure;

import LegendaryCardMaker.CustomCardMaker.ALIGNMENT;
import LegendaryCardMaker.CustomCardMaker.CustomCardMaker;
import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import LegendaryCardMaker.LegendaryHeroMaker.MotionBlurOp;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.SwingUtilities;

public class ElementCardName
extends CustomElement
implements Cloneable {
    public String defaultValue;
    public boolean includeSubname;
    public String subnameText;
    public boolean subnameEditable;
    public ALIGNMENT alignment = ALIGNMENT.CENTER;
    public boolean allowChange;
    public int x;
    public int y;
    public Color colour;
    public boolean drawUnderlay;
    public int blurRadius;
    public boolean blurDouble;
    public int blurExpand;
    public Color highlightColour;
    public int textSize;
    public int subnameSize;
    public String fontName;
    public int fontStyle;
    public boolean uppercase;
    public HIGHLIGHT highlight = HIGHLIGHT.NONE;
    public int subnameGap = -1;
    public String value;
    public String subnameValue;

    @Override
    public void drawElement(Graphics2D g) {
        if (this.getValue() != null) {
            BufferedImage bi = new BufferedImage(CustomCardMaker.cardWidth, CustomCardMaker.cardHeight, 2);
            Graphics2D g2 = this.getGraphics(bi);
            g2 = this.setGraphicsHints(g2);
            if (this.colour != null) {
                g2.setColor(this.colour);
            }
            Font font = null;
            try {
                font = Font.createFont(0, new File("Percolator.otf"));
                font = font.deriveFont((float)this.textSize);
            }
            catch (Exception e) {
                e.printStackTrace();
                font = new Font("Percolator", 0, this.textSize);
            }
            if (this.fontName != null) {
                font = new Font(this.fontName, this.fontStyle, this.textSize);
            }
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics(font);
            int stringLength = SwingUtilities.computeStringWidth(metrics, this.getValueForDraw());
            g2 = this.setGraphicsHints(g2);
            int newx = this.x;
            if (this.alignment.equals((Object)ALIGNMENT.CENTER)) {
                newx = this.x - stringLength / 2;
            }
            if (this.alignment.equals((Object)ALIGNMENT.RIGHT)) {
                newx = this.x - stringLength;
            }
            LineMetrics lm = metrics.getLineMetrics(this.getValueForDraw(), g2);
            int yModified = this.y + (int)(lm.getAscent() - lm.getDescent());
            int bannerStart = yModified - (int)lm.getAscent() + (int)lm.getDescent() - this.getPercentage(CustomCardMaker.cardHeight, 0.01);
            int bannerEnd = yModified + this.getPercentage(CustomCardMaker.cardHeight, 0.015);
            int subnameStartY = yModified + (int)lm.getDescent() + (int)(lm.getDescent() / 2.0f);
            if (this.subnameGap >= 0) {
                subnameStartY = yModified + this.subnameGap;
            }
            int newxSubname = this.x;
            int yModifiedSubname = subnameStartY;
            Font fontSubname = null;
            if (this.includeSubname) {
                fontSubname = font.deriveFont((float)this.subnameSize);
                g2.setFont(fontSubname);
                metrics = g2.getFontMetrics(fontSubname);
                stringLength = SwingUtilities.computeStringWidth(metrics, this.getSubnameValueForDraw());
                if (this.alignment.equals((Object)ALIGNMENT.CENTER)) {
                    newxSubname = this.x - stringLength / 2;
                }
                if (this.alignment.equals((Object)ALIGNMENT.RIGHT)) {
                    newxSubname = this.x - stringLength;
                }
                lm = metrics.getLineMetrics(this.getValueForDraw(), g2);
                yModifiedSubname = subnameStartY + (int)(lm.getAscent() - lm.getDescent());
                g2.setFont(font);
                metrics = g2.getFontMetrics(font);
                bannerEnd = yModifiedSubname + this.getPercentage(CustomCardMaker.cardHeight, 0.015);
            }
            if (this.highlight.equals((Object)HIGHLIGHT.BLUR)) {
                g2 = this.setGraphicsHints(g2);
                g2.drawString(this.getValueForDraw(), newx, yModified);
                if (this.includeSubname) {
                    g2.setFont(fontSubname);
                    metrics = g2.getFontMetrics(fontSubname);
                    g2 = this.setGraphicsHints(g2);
                    g2.drawString(this.getSubnameValueForDraw(), newxSubname, yModifiedSubname);
                    g2.setFont(font);
                    metrics = g2.getFontMetrics(font);
                    g2 = this.setGraphicsHints(g2);
                }
                this.drawUnderlay(bi, g2, 2, 0, 0, this.blurRadius, this.blurDouble, this.blurExpand, this.highlightColour);
            }
            if (this.highlight.equals((Object)HIGHLIGHT.BANNER)) {
                BufferedImage bi2 = new BufferedImage(CustomCardMaker.cardWidth, CustomCardMaker.cardHeight, 2);
                Graphics g3 = bi2.getGraphics();
                int bannerHeight = bannerEnd - bannerStart;
                g3.setColor(this.highlightColour);
                g3.fillRect(CustomCardMaker.cardWidth / 2, bannerStart - this.getPercentage(CustomCardMaker.cardHeight, 0.005), this.getPercentage(CustomCardMaker.cardWidth, 0.15), bannerHeight);
                MotionBlurOp op = new MotionBlurOp();
                op.setDistance(200.0f);
                bi2 = op.filter(bi2, null);
                this.makeTransparent(bi2, 0.8);
                g2.drawImage((Image)bi2, 0, 0, null);
                AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                tx.translate(-bi2.getWidth(null), 0.0);
                AffineTransformOp aop = new AffineTransformOp(tx, 1);
                bi2 = aop.filter(bi2, null);
                g2.drawImage((Image)bi2, 0, 0, null);
            }
            g2 = this.setGraphicsHints(g2);
            g2.drawString(this.getValueForDraw(), newx, yModified);
            if (this.includeSubname) {
                g2.setFont(fontSubname);
                metrics = g2.getFontMetrics(fontSubname);
                g2 = this.setGraphicsHints(g2);
                g2.drawString(this.getSubnameValueForDraw(), newxSubname, yModifiedSubname);
                g2.setFont(font);
                metrics = g2.getFontMetrics(font);
                g2 = this.setGraphicsHints(g2);
            }
            g.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
        }
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    private String getValueForDraw() {
        if (this.uppercase && this.getValue() != null) {
            return this.getValue().toUpperCase();
        }
        return this.getValue();
    }

    public String getSubnameValue() {
        if (this.subnameValue != null) {
            return this.subnameValue;
        }
        return this.subnameText;
    }

    private String getSubnameValueForDraw() {
        if (this.uppercase && this.getSubnameValue() != null) {
            return this.getSubnameValue().toUpperCase();
        }
        return this.getSubnameValue();
    }

    private BufferedImage makeTransparent(BufferedImage bi, double percent) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(bi.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int col = this.getPercentage(originalColor.getAlpha(), percent) << 24 | originalColor.getRed() << 16 | originalColor.getGreen() << 8 | originalColor.getBlue();
                    bi.setRGB(xx, yy, col);
                }
                ++yy;
            }
            ++xx;
        }
        return bi;
    }

    @Override
    public String generateOutputString() {
        return this.generateOutputString(false);
    }

    @Override
    public String generateOutputString(boolean fullExport) {
        String str = "";
        if (this.value != null) {
            str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";value;" + this.value + "\n";
        }
        if (this.subnameValue != null) {
            str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";subnameValue;" + this.subnameValue + "\n";
        }
        str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";visible;" + this.visible + "\n";
        return str;
    }

    public static enum HIGHLIGHT {
        BANNER,
        BLUR,
        NONE;

    }
}

